<?php
session_start();
include '../includes/db_connection.php'; // include your DB connection

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email_username = trim($_POST['email-username']);
    $password = trim($_POST['password']);

    // Prepared statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT id, username, email, password FROM users WHERE email = ? OR username = ? LIMIT 1");
    $stmt->bind_param("ss", $email_username, $email_username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        // Verify password (assuming hashed with password_hash)
        if (password_verify($password, $row['password'])) {
            // Set session
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['username'] = $row['username'];

            echo json_encode(["status" => "success", "message" => "Valid Credentials"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Invalid password"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "User not found"]);
    }
}
?>
